#include <stdio.h>
#include <stdlib.h>

int fib(int n) {
    if (n <= 1)
        return 1;
    return fib(n-1) + fib(n-2);
}

/// euklidov algoritam
int nzd(int a, int b) {
    if (a == 0)
        return b;
    else if (b == 0)
        return a;
    return nzd(b, a%b);
}

int pow(int a, int n) {
    if (n == 0)
        return 1;
    else
        return a*pow(a, n-1);
}

void print_arr(int a[], int n) {
    if (n == 1) {
        printf("%d\n", a[0]);
        return;
    }
    printf("%d ", a[0]);
    print_arr(a+1, n-1);
}

int sum_arr(int a[], int n) {
    // mogao je i bazni slucaj za n == 0 da se vrati 0
    if (n == 1)
        return a[0];
    return a[0] + sum_arr(a+1, n-1);
}

/// za vjezbu: naci min/max niza

void print_arr_rev(int a[], int n) {
    if (n == 1) {
        printf("%d\n", a[0]);
        return;
    }
    printf("%d ", a[n-1]);
    print_arr_rev(a, n-1);
}

int strlen_rek(char* s) {
    if (s[0] == '\0')
        return 0;
    return 1 + strlen_rek(s+1);
}

char* search_rek(char* s, char c) {
    if (s[0] == '\0')
        return NULL;
    if (s[0] == c)
        return s;
    return search_rek(s+1, c);
}

void strcpy_rek(char* s1, char* s2) {
    if (s2[0] == '\0') {
        s1[0] = '\0';
        return;
    }
    s1[0] = s2[0];
    strcpy_rek(s1+1, s2+1);
}

int palindrom_rek(char* s, int n) {
    if (n <= 1)
        return 1;
    if (s[0] != s[n-1])
        return 0;
    return palindrom_rek(s+1, n-2);
}

/// za vjezbu - rekurzivno nadovezivanje stringova, strncpy_rek, poredjenje (strcmp_rek, strncmp_rek)

int main()
{
    printf("%d\n", fib(5));

    printf("%d\n", nzd(72, 240));
    printf("%d\n", nzd(13, 21));

    printf("%d\n", pow(2, 10));

    int a[5] = {1,2,3,4,5};
    print_arr(a, 5);
    print_arr_rev(a, 5);

    printf("%d\n", strlen_rek("abcd"));

    char* s = "abcdxyz";
    printf("%p %p\n", s, search_rek(s, 'd'));

    char s1[100];
    char s2[100] = "abcd";
    strcpy_rek(s1, s2);
    puts(s1);

    printf("%d\n", palindrom_rek("abccba", 6));

    return 0;
}
